/*
This software module was originally developed by 
        Hang-Seop Lee (hslee@etri.re.kr), ETRI
        Jung-Chul Lee (jclee@etri.re.kr), ETRI
and edited by Hang-Seop Lee, Jung-Chul Lee of ETRI, 
in the course of development of the MPEG-4.
This software module is an implementation of a part of one or
more MPEG-4 tools as specified by the MPEG-4.
ISO/IEC gives users of the MPEG-4 free license to this                
software module or modifications thereof for use in hardware
or software products claiming conformance to the MPEG-4.
Those intending to use this software module in hardware or software
products are advised that its use may infringe existing patents.
The original developer of this software module and his/her company,
the subsequent editors and their companies, and ISO/IEC have no
liability for use of this software module or modifications thereof
in an implementation.
Copyright is not released for non MPEG-4 conforming
products. ETRI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to
inhibit third parties from using the code for non
MPEG-4 conforming products.
This copyright notice must be included in all copies or
derivative works. Copyright (c) 1997.
*/    

// LipSyncDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Modeless.h"
#include "LipSyncDlg.h"
#include <io.h>			// for _access();

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int	nLIPSHAPE;		// Լ ¸ ϱ  

CLipSyncDlg* pCLip=NULL;

/////////////////////////////////////////////////////////////////////////////
// CLipSyncDlg dialog


CLipSyncDlg::CLipSyncDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLipSyncDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLipSyncDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pCtrlDlg = NULL;		// insert by ׼
}

CLipSyncDlg::CLipSyncDlg(CDialog* pDlg)		// modeless constructor
{
	m_pCtrlDlg = pDlg;
}

CLipSyncDlg::~CLipSyncDlg()
{
}

BOOL CLipSyncDlg::Create()
{
	return CDialog::Create(IDD_LIP_SYNC);
}

void CLipSyncDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLipSyncDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLipSyncDlg, CDialog)
	//{{AFX_MSG_MAP(CLipSyncDlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLipSyncDlg message handlers

BOOL CLipSyncDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	MoveWindow(450, 144, 252, 214);

	m_posBitmap.x = 5;
	m_posBitmap.y = 5;

	BITMAP	bm;
	CBitmap	bitmap;
	bitmap.LoadBitmap(IDB_BITMAP_00);
	bitmap.GetObject(sizeof(BITMAP), &bm);

	m_sizeBitmap.cx = bm.bmWidth;
	m_sizeBitmap.cy = bm.bmHeight;	

	pCLip = this;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLipSyncDlg::OnPaint() 
{
	
	// TODO: Add your message handler code here
	CPaintDC dc(this);	// device context for painting
	CDC dcMem;			// memory device context

	CBitmap bitmap;
	switch( nLIPSHAPE )
	{
	case	0 :	bitmap.LoadBitmap(IDB_BITMAP_00);		break;
	case	3 :	bitmap.LoadBitmap(IDB_BITMAP_03);		break;
	case	4 :	bitmap.LoadBitmap(IDB_BITMAP_04);		break;
	case	5 :	bitmap.LoadBitmap(IDB_BITMAP_05);		break;
	case	9 :	bitmap.LoadBitmap(IDB_BITMAP_09);		break;
	case	11 :	bitmap.LoadBitmap(IDB_BITMAP_11);	break;
	case	12 :	bitmap.LoadBitmap(IDB_BITMAP_12);	break;
	case	13 :	bitmap.LoadBitmap(IDB_BITMAP_13);	break;
	case	14 :	bitmap.LoadBitmap(IDB_BITMAP_14);	break;
	case	17 :	bitmap.LoadBitmap(IDB_BITMAP_17);	break;
	case	18 :	bitmap.LoadBitmap(IDB_BITMAP_18);	break;
	case	19 :	bitmap.LoadBitmap(IDB_BITMAP_19);	break;
	case	24 :	bitmap.LoadBitmap(IDB_BITMAP_24);	break;
	case	25 :	bitmap.LoadBitmap(IDB_BITMAP_25);	break;
	case	26 :	bitmap.LoadBitmap(IDB_BITMAP_26);	break;
	case	27 :	bitmap.LoadBitmap(IDB_BITMAP_27);	break;
	case	28 :	bitmap.LoadBitmap(IDB_BITMAP_28);	break;
	case	29 :	bitmap.LoadBitmap(IDB_BITMAP_29);	break;
	case	32 :	bitmap.LoadBitmap(IDB_BITMAP_32);	break;
	case	33 :	bitmap.LoadBitmap(IDB_BITMAP_33);	break;
	case	34 :	bitmap.LoadBitmap(IDB_BITMAP_34);	break;
	case	35 :	bitmap.LoadBitmap(IDB_BITMAP_35);	break;
	case	36 :	bitmap.LoadBitmap(IDB_BITMAP_36);	break;
	case	37 :	bitmap.LoadBitmap(IDB_BITMAP_37);	break;
	case	38 :	bitmap.LoadBitmap(IDB_BITMAP_38);	break;
	case	41 :	bitmap.LoadBitmap(IDB_BITMAP_41);	break;
	case	42 :	bitmap.LoadBitmap(IDB_BITMAP_42);	break;
	case	43 :	bitmap.LoadBitmap(IDB_BITMAP_43);	break;
	case	46 :	bitmap.LoadBitmap(IDB_BITMAP_46);	break;
	case	47 :	bitmap.LoadBitmap(IDB_BITMAP_47);	break;
	case	50 :	bitmap.LoadBitmap(IDB_BITMAP_50);	break;
	case	53 :	bitmap.LoadBitmap(IDB_BITMAP_53);	break;
	case	54 :	bitmap.LoadBitmap(IDB_BITMAP_54);	break;
	case	55 :	bitmap.LoadBitmap(IDB_BITMAP_55);	break;
	case	58 :	bitmap.LoadBitmap(IDB_BITMAP_58);	break;
	case	60 :	bitmap.LoadBitmap(IDB_BITMAP_60);	break;
	case	61 :	bitmap.LoadBitmap(IDB_BITMAP_61);	break;
	case	63 :	bitmap.LoadBitmap(IDB_BITMAP_63);	break;
	case	64 :	bitmap.LoadBitmap(IDB_BITMAP_64);	break;
	case	66 :	bitmap.LoadBitmap(IDB_BITMAP_66);	break;
	case	68 :	bitmap.LoadBitmap(IDB_BITMAP_68);	break;
	case	69 :	bitmap.LoadBitmap(IDB_BITMAP_69);	break;
	case	70 :	bitmap.LoadBitmap(IDB_BITMAP_70);	break;
	case	72 :	bitmap.LoadBitmap(IDB_BITMAP_72);	break;
	case	74 :	bitmap.LoadBitmap(IDB_BITMAP_74);	break;
	case	80 :	bitmap.LoadBitmap(IDB_BITMAP_80);	break;
	case	82 :	bitmap.LoadBitmap(IDB_BITMAP_82);	break;
	case	83 :	bitmap.LoadBitmap(IDB_BITMAP_83);	break;
	default :
		break;	
	}
	
	// create a memory device context
	dcMem.CreateCompatibleDC(&dc);

		// select the bitmap into the memory device context
	CBitmap* pOldBitmap = dcMem.SelectObject(&bitmap);

	// transfer the memory device context to the display context
	dc.BitBlt(m_posBitmap.x, m_posBitmap.y,	
	m_sizeBitmap.cx, m_sizeBitmap.cy, &dcMem, 0, 0, SRCCOPY);

	dcMem.SelectObject(pOldBitmap);	// unselect bitmap
	
	// Do not call CDialog::OnPaint() for painting messages
}


// ϴ Լ  ׷ֱ  Լ
//  OnPaint() Լ ڵ ȣѴ.
BOOL CLipSyncDlg::ChangeBitmap(int n_LipShape)
{
	// TODO: Add your control notification handler code here
	nLIPSHAPE = n_LipShape;
	
	// create bitmap bounding rectangle  
	CRect rect(m_posBitmap.x, m_posBitmap.y, 
	m_posBitmap.x + m_sizeBitmap.cx, m_posBitmap.y + m_sizeBitmap.cy);

	// invalidate dialog, causing bitmap to be redraw with new text 
	InvalidateRect(rect, FALSE);	

	return 0;
}
